
/****** Object:  StoredProcedure [dbo].[usp_EFR_GetReferralDateByPatientId]    Script Date: 12/19/2013 08:04:59 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_EFR_GetReferralDateByPatientId]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_EFR_GetReferralDateByPatientId]
GO

/****** Object:  StoredProcedure [dbo].[usp_EFR_GetReferralDateByPatientId]    Script Date: 12/19/2013 08:04:59 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


-- ===============================================
-- Author:		Atlee Whiteleather
-- Create date: 12/19/2013
-- Description:	Use to return the # of 
--              referrals for the given patient
-- ===============================================

CREATE PROCEDURE [dbo].[usp_EFR_GetReferralDateByPatientId]
	 @PATIENT_ID int
AS
BEGIN
	declare @result datetime
	
	set @result = 
		(
		 SELECT   top(1)  created
		 FROM Referral
		 where referral.STD_REGISTRY_ID = 1
		 and patient_id = @PATIENT_ID
		 order by CREATED desc
		 )

	select (@result) as [ReferralDate]
END

GO


INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('R6'
           ,'00'
           ,'001'
           ,0
           ,'30941  Two workflows created from one manually created referral'
		   ,'Script will be utilized to help prevent multiple referrals (2)'
           ,'EFR'
           ,GETDATE())

GO

---------------------------------------------------------------------------------

-- Data was inadvertently entered for wkf_case_id 108669. This script will undo 
-- that data entry.

-- Atlee Whiteleather
-- 12/20/2013  

declare @referralId int 
set @referralId = 4812181  

-- delete the workflow_activity

delete WKF_CASE_ACTIVITY 
from wkf_case_activity wca
join wkf_case wc on wc.wkf_case_id = wca.wkf_case_id
where wc.referral_id = @referralId
-- 
-- Delete the workflow case itself, if it exists
--

delete WKF_CASE 
where REFERRAL_ID = @referralId

-- delete referral

delete referral
where referral_id = @referralId
	

print 'Completed updates' 


INSERT INTO [dbo].[DatabaseChangeLog]
           ([MajorReleaseNumber]
           ,[MinorReleaseNumber]
           ,[PointReleaseNumber]
           ,[Hotfix]
           ,[ScriptName]
           ,[ScriptDescription]
           ,[TargetRegistry]
           ,[DateApplied])
     VALUES
           ('R6'
           ,'00'
           ,'001'
           ,0
           ,'30941 - Remove Duplicate Referral'
		   ,'Script will remove the duplicate referral created - 4812181 (2)'
           ,'EFR'
           ,GETDATE())

GO
